#pragma once

#define UWM_BUTTON_CLICKED	(WM_USER + 10)

#include "SnapPreviewCommon.h"
#include "ToolbarDialog.h"
#include "afxcmn.h"



enum ENM_PLAYER_BUTTONS
{
	kSVPB_NONE		= 0x0000,
	kSVPB_FIRST		= 0x0001,
	kSVPB_PREV		= 0x0002,
	kSVPB_PLAY		= 0x0004,
	kSVPB_STOP		= 0x0008,
	kSVPB_NEXT		= 0x0010,
	kSVPB_LAST		= 0x0020,
	kSVPB_ALL			= 0x003F,
};



// SnapPreviewDialog
class CSnapPreviewDialog : public CXTResizeDialog
{
	DECLARE_DYNAMIC(CSnapPreviewDialog)

public:				// Construction & destruction
	CSnapPreviewDialog( CWnd* pParent = NULL );
	virtual ~CSnapPreviewDialog();

public:				// Dialog Data
	enum { IDD = IDD_SV_CONTROLS };
	CString			m_strFolder;
	CSliderCtrl	m_sldSpeed;
	CSliderCtrl	m_sldFrame;
	BOOL				m_bUpdateText;
	BOOL				m_bUpdateImages;
	BOOL				m_bKeepAspectR;

public:			// Operations
	void SetCommonData(SV_COMMON_DATA *pCD) { m_pCD = pCD; }
	void EnablePlayerButtons();
private:
	void DrawPlayerButtons(ENM_PLAYER_BUTTONS eb);
	void OnPlayerFirst();
	void OnPlayerPrev();
	void OnPlayerPlay();
	void OnPlayerStop();
	void OnPlayerNext();
	void OnPlayerLast();

protected:	// Virtual overrides
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

protected:	// Message handlers
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnBnFolderClicked();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnBnClickedSvchkUpdatetext();
	afx_msg void OnBnClickedSvchkUpdateimages();
	afx_msg void OnBnClickedSvchkKeepaspectr();
	afx_msg void OnBnClickedColorPicker();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnDestroy();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	DECLARE_MESSAGE_MAP()

private:		// Member data
	CBitmap							m_bmControlBoard, m_bmPlayerBtns, *m_pBmCB, *m_pBmPB;
	CDC									m_dcControlBoard, m_dcPlayerBtns;
	CRect								m_rcPlayer;
	int									m_nEnabled;
	ENM_PLAYER_BUTTONS	m_eDown;
	int									m_nPlayerClick;
	CRect								m_arrButtons[6];
	CBrush							m_brSlider;

	CXTColorPicker			m_colorPickBtn;		// Color picker button
	CFixedToolTip				m_ctlTT;					// Tool tips
	int									m_nTimerVar;

	SV_COMMON_DATA *m_pCD;
};



// SnapPreviewControls docking frame
class CSnapPreviewControls : public CToolbarDialog
{
	DECLARE_DYNAMIC(CSnapPreviewControls)

public:			// Construction & destruction
	CSnapPreviewControls();   // standard constructor
	virtual ~CSnapPreviewControls();

public:			// Dialog Data
	enum { IDD = IDD_DATABASE };

protected:	// Message handlers
	DECLARE_MESSAGE_MAP()
};
